﻿///
/// アーカイブボリュームファイルをフォルダに展開する実装クラス ArchiveFileExtractorImpl のヘッダファイル。
/// Internal: 非公開ヘッダファイル。
///

#if       !defined(INCLUDED_SZ_ARCHIVE_FILE_EXTRACTOR_IMPL)
#define            INCLUDED_SZ_ARCHIVE_FILE_EXTRACTOR_IMPL

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

#include  <Common/MyCom.h>
#include  <7zip/UI/Common/ArchiveOpenCallback.h>
#include  <7zip/UI/Common/ArchiveExtractCallback.h>

SZ_NS_BEG(szpp)

/// <summary>
/// アーカイブファイルをファイルシステム上のフォルダに展開する簡単な展開処理を実現するための実装クラス。
/// </summary>
/// <notes>
/// クライアントが 7-Zip ヘッダを参照しなくて良いように、実装詳細は完全にこのクラスに分離してある。
/// </notes>
class SZ_SPEC ArchiveFileExtractorImpl :
  public IOpenCallbackUI,
  public IExtractCallbackUI,
#ifndef _NO_CRYPTO
  public ICryptoGetTextPassword,
#endif
  public CMyUnknownImp
{
public:

  ArchiveFileExtractorImpl(
    ArchiveOpenClientCallback *openCallback,
    ArchiveFileExtractClientCallback *extCallback,
    GetPasswordClientCallback *pwdCallback);
  ~ArchiveFileExtractorImpl();

#pragma region 7-Zip インターフェース実装

#ifndef _NO_CRYPTO
  MY_UNKNOWN_IMP2(
      IFolderArchiveExtractCallback,
      ICryptoGetTextPassword
      )
#else
  MY_UNKNOWN_IMP1(
      IFolderArchiveExtractCallback
      )
#endif

  // IOpenCallbackUI
#ifndef _NO_CRYPTO
  virtual HRESULT Open_CryptoGetTextPassword(BSTR *password);
  virtual HRESULT Open_GetPasswordIfAny(UString &password);
  virtual bool Open_WasPasswordAsked();
  virtual void Open_ClearPasswordWasAskedFlag();
#endif
  virtual HRESULT Open_CheckBreak();
  virtual HRESULT Open_SetTotal(const UInt64 *files, const UInt64 *bytes);
  virtual HRESULT Open_SetCompleted(const UInt64 *files, const UInt64 *bytes);

  // IProgress
  STDMETHODIMP SetTotal(UInt64 total);
  STDMETHODIMP SetCompleted(const UInt64 *completeValue);

#ifndef _NO_CRYPTO
  // IPassword
  STDMETHODIMP CryptoGetTextPassword(BSTR *password);
#endif

  // IExtractCallbackUI (IFolderArchiveExtractCallback portion)
  STDMETHODIMP AskOverwrite(
      const wchar_t *existName, const FILETIME *existTime, const UInt64 *existSize,
      const wchar_t *newName, const FILETIME *newTime, const UInt64 *newSize,
      Int32 *answer);
  STDMETHODIMP PrepareOperation(const wchar_t *name, bool isFolder, Int32 askExtractMode, const UInt64 *position);
  STDMETHODIMP MessageError(const wchar_t *message);
  STDMETHODIMP SetOperationResult(Int32 operationResult, bool encrypted);

  // IExtractCallbackUI
  virtual HRESULT BeforeOpen(const wchar_t *name);
  virtual HRESULT OpenResult(const wchar_t *name, HRESULT result, bool encrypted);
  virtual HRESULT ThereAreNoFiles();
  virtual HRESULT ExtractResult(HRESULT result);
#ifndef _NO_CRYPTO
  virtual HRESULT SetPassword(const UString &password);
#endif

#pragma endregion

#ifndef _NO_CRYPTO
  void SetInitialPassword(const szstring &password);
#endif

private:

#ifndef _NO_CRYPTO
  bool openPwdDefined;
  bool openPwdAsked;
  szstring openPwd;

  bool extPwdDefined;
  szstring extPwd;
#endif

  ArchiveOpenClientCallback        *openCallback;
  ArchiveFileExtractClientCallback *extCallback;
  GetPasswordClientCallback        *pwdCallback;
};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_FILE_EXTRACTOR_IMPL)
